/*
 * Decompiled with CFR 0.152.
 */
package com.odinokland.constantmusic;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import com.odinokland.constantmusic.mixin.MusicManagerAccessor;
import com.odinokland.constantmusic.platform.Services;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CommonClass {
    public static final Path configFile = Paths.get(Services.PLATFORM.getConfigFolder().toString(), "constantmusic.toml");
    private static boolean manualConfigInitialized = false;
    private static int timer = 0;

    public static void init() {
        if (Services.PLATFORM.isModLoaded("constantmusic")) {
            // empty if block
        }
    }

    public static int readValue() {
        Toml toml = new Toml().read(new File(configFile.toString()));
        return toml.getLong("timer").intValue();
    }

    public static void writeValue(int value) {
        TomlWriter tomlWriter = new TomlWriter();
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("timer", value);
            tomlWriter.write(map, new File(configFile.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getTimer() {
        if (!manualConfigInitialized) {
            try {
                timer = CommonClass.readValue();
                manualConfigInitialized = true;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return timer;
    }

    public static void setTimer(int value) {
        CommonClass.writeValue(value);
        timer = value;
    }

    public static OptionInstance<Integer> getConfigOption() {
        return new OptionInstance("constantmusic.option", OptionInstance.m_231498_(), (component, integer) -> integer.equals(0) ? Component.m_237110_((String)"options.generic_value", (Object[])new Object[]{component, CommonComponents.f_130654_}) : CommonClass.timeDisplayText(integer), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 600), (Object)CommonClass.getTimer(), integer -> CommonClass.setTimer(Integer.parseInt(integer.toString())));
    }

    public static MutableComponent timeDisplayText(Integer seconds) {
        int minutes = seconds / 60;
        int remainingSeconds = seconds % 60;
        if (minutes > 0) {
            return Component.m_237110_((String)"constantmusic.option.minutes_and_seconds", (Object[])new Object[]{minutes, remainingSeconds});
        }
        return Component.m_237110_((String)"constantmusic.option.seconds", (Object[])new Object[]{seconds});
    }

    public static void addDebugText(List<String> texts) {
        MusicManager manager = Minecraft.m_91087_().m_91397_();
        if (manager instanceof MusicManagerAccessor) {
            MusicManagerAccessor accessor = (MusicManagerAccessor)manager;
            SoundInstance currentMusic = accessor.getCurrentMusic();
            if (currentMusic == null) {
                texts.add(Component.m_237110_((String)"constantmusic.debug.timer", (Object[])new Object[]{accessor.getTimer()}).getString());
            } else {
                texts.add(Component.m_237110_((String)"constantmusic.debug.music", (Object[])new Object[]{currentMusic.m_7904_()}).getString());
            }
        }
    }
}

